VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Output_Class"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Private Const MODULE_NAME As String = "Output_Class"

Implements EzeScan_Interfaces.IOutput

Private outputParameters_() As EzeScan_Interfaces.UserConfigurableParameter

Private Sub Class_Initialize()
    Dim no_yes() As String
    
    ' create an array of values to be used by the lookup parameter
    no_yes = Split("No,Yes", ",")
    
    ' Create the output parameters
    PluginHelper.AddParameter outputParameters_, PluginHelper.CreateLookupParameter("inc", "Increment Doc ID", ParameterType_Lookup, no_yes(1), "Increment the Document ID", no_yes, False)
End Sub

Private Function IOutput_EditCustomParameter(ByVal parameter_id As String, output_parameters() As EzeScan_Interfaces.UserConfigurableParameter, value_out As String) As Long
    ' See Connection_Class.IConnection_EditCustomParameter() for a description of this function
    ' This plugin output object does not contain any custom parameters - so the return code is always cancel just in case this function is ever called in error
    IOutput_EditCustomParameter = 0
End Function

Private Function IOutput_OutputDocument(ByVal document_path As String, output_parameters() As EzeScan_Interfaces.UserConfigurableParameter, ByVal previous_document_reference As String) As Long
    
    On Error GoTo errHandler
    
    Dim return_code As Long
    Dim increment_id As Boolean
    Dim param_index As Long
    Dim base_folder As String
    Dim target_file_path As String
    Dim document_id As String
    
    document_id = previous_document_reference
    
    ' Process the parameters
    
    For param_index = 0 To (PluginHelper.ParameterCount(output_parameters) - 1)
        
        Select Case output_parameters(param_index).ID
            Case "inc"
                increment_id = (output_parameters(param_index).Value = "Yes")
                DebugLog.LogPluginMessage "Increment ID: " & IIf(increment_id, "Yes", "No"), PluginDebugLevel_InfoNormal
        End Select
        
    Next param_index

    If document_id <> "" Then
        
        Select Case MsgBox("Replace existing document with new version?", vbYesNoCancel)
            Case vbYes
                DebugLog.LogPluginMessage "Add new version of: " & document_id, PluginDebugLevel_InfoNormal
            Case vbNo
                DebugLog.LogPluginMessage "Ignoring previous document reference: " & document_id, PluginDebugLevel_InfoNormal
                document_id = ""
            Case vbCancel
                DebugLog.LogPluginMessage "Cancelling Output", PluginDebugLevel_InfoNormal
                IOutput_OutputDocument = 0
                Exit Function
        End Select
    
    End If
    
    base_folder = FSO.BuildPath(StorageFolder, UserName)
        
    If document_id = "" Then
        document_id = "1"
        
        Do While increment_id And FSO.FileExists(FSO.BuildPath(base_folder, document_id & "." & FSO.GetExtensionName(document_path)))
            document_id = CStr(CLng(document_id) + 1)
        Loop
        
        DebugLog.LogPluginMessage "Using new document reference: " & document_id, PluginDebugLevel_InfoNormal
    End If
    
    If (Not FSO.FolderExists(base_folder)) Then
        DebugLog.LogPluginMessage "Creating Folder: " & base_folder, PluginDebugLevel_InfoNormal
        FSO.CreateFolder base_folder
    End If
    
    target_file_path = FSO.BuildPath(base_folder, document_id & "." & FSO.GetExtensionName(document_path))
    
    If FSO.FileExists(target_file_path) Then
        DebugLog.LogPluginMessage "Removing existing file: " & target_file_path, PluginDebugLevel_InfoNormal
        FSO.DeleteFile target_file_path, True
    End If
    
    DebugLog.LogPluginMessage "Saving file: " & target_file_path, PluginDebugLevel_InfoNormal
    FSO.CopyFile document_path, target_file_path, False
        
    PreviousDocumentReference = document_id
    IOutput_OutputDocument = 1 ' success
    
Exit Function
errHandler:

    DebugError MODULE_NAME, "IOutput_OutputDocument"
    DebugLog.LogUserErrorMessage "Output error: " & Err.Description
    IOutput_OutputDocument = -99  ' error
    
End Function

Private Property Get IOutput_OutputParameters() As EzeScan_Interfaces.UserConfigurableParameter()
    ' EzeScan calls this property to retrieve an array of parameters that are required to output a document
    IOutput_OutputParameters = outputParameters_
End Property
